<?php

namespace Fusionalliance\Controlforms;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FormRow extends Model 
{

    protected $table = 'form_rows';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('major_number', 'minor_number', 'diminutive_number');
    protected $visible = array('major_number', 'minor_number', 'diminutive_number', 'sort_order');

    public function controlForm()
    {
        return $this->belongsTo('ControlForm');
    }

}